Ext.define('Photoalbum.view.DetailInfo', {
	extend: 'Ext.Panel',
	xtype: 'photoalbum-detail-info',
	id: 'detailinfo',
	initialized: false,

    config : {
    	title: 'Information',
    	scrollable: true,
    	items: []
    },
    
    bindAudio: function(url) {
    	this.add(
	    		{
	    			xtype: 'fieldset',
	    			title: 'Audiobeschreibung:',
	    			items: Ext.os.is.Android ? [{
	    			    xtype: 'audio',
	    			    url: url,
	    			    loop: false,
	    			    enableControls: false
	    			}, {
	    				xtype : 'button',
	    			    text  : 'Abspielen',
	    				margin: 20,
	    			    handler: function() {
	    			    	var audio = this.getParent().down('audio');
		    			    if (audio.isPlaying()) {
		    			    	audio.pause();
		    			        this.setText('Abspielen');
		    			    } else {
		    			    	audio.play();
		    			        this.setText('Pause');
		    			    }
	    			    }
	    			}, {
			    		xtype: 'button',
			    		id: 'delaudio',
			    		ui: 'round',
			    		iconMask: true,
			    		iconCls: 'trash'
			    	}] : [{
			            xtype: 'audio',
			            url: url,
			            loop: false
		    		},{
		    			xtype: 'button',
		    			id: 'delaudio',
		    			ui: 'round',
		    			iconMask: true,
		    			iconCls: 'trash'
		    		}]
	    		}
    	);
    },
    
    bindDescription: function(description) {
    	this.add(
    			{
    				xtype: 'fieldset',
    				title: 'Bildbeschreibung:',
    				items: [{
                        xtype: 'textareafield',
                        id: 'description',
                        name : 'description',
                        labelWidth: 0,
                        value: description
    				}, {
    					xtype: 'button',
    					iconMask: true,
    					iconCls: 'mic',
    					id: 'record'
    				}]
    			}
    	);
    },
    
    bindTags: function(tags) {
    	this.add(
        		{
        			xtype: 'fieldset',
        			title: 'Schlagw&ouml;rter',
        			items: [{
            			xtype: 'list',
            			id: 'taglist',
            			itemTpl: '{name}',
            			scrollable: false,
            			onItemDisclosure : function() {},
            			store: Ext.create('Ext.data.ArrayStore', {
            				fields: ['name'],
            				data: tags
					    })    
        			},{
               			xtype: 'fieldset',
               			layout: 'hbox',
               			items: [{
        	       			xtype: 'textfield',
        	       			id: 'newtag',
        	       			flex: 12
               			},{
        	       			xtype: 'button',
        	       			flex: 1,
        	       			id: 'addtag',
        	       			iconMask: true,
        	       			iconCls: 'add'
               			}]
               		}]
        		}
    	);
    }
});